'--------------------------------------------------------------
'                     (c) 1999-2002 MCS Electronics
'--------------------------------------------------------------
'  file: I2C.BAS
'  demo: I2CSEND and I2CRECEIVE
'--------------------------------------------------------------
$baud = 9600
$crystal = 8000000
Config Scl = Portc.0
Config Sda = Portc.1
Config Portb = Output
Declare Sub Write_ioexp(byval Data As Byte )
Declare Sub Read_ioexp(value As Byte)

Const Addressw = &H70                                       'slave write address of PCF8574A
Const Addressr = &H71                                       'slave read address of PCF8574A

Dim B As Byte , Value As Byte                               'dim byte
Print : Print "Test expanding 8 bit I/O with PCF8574A"
 Portb = &HFF
 Do
 Call Read_ioexp(b)
 Portb = B
 Loop
End                                                         'end program

Sub Write_ioexp(byval Data As Byte)
    I2cstart                                                'start condition
    I2cwbyte Addressw                                       'slave address
    I2cwbyte Data                                           'value to write
    I2cstop                                                 'stop condition
    Waitms 10                                               'wait for 10 milliseconds
End Sub

Sub Read_ioexp(value As Byte)
   I2cstart                                                 'generate start
   I2cwbyte Addressr                                        'slave address (read)
   I2crbyte Value , Nack                                    'read byte
   I2cstop                                                  'generate stop

   End Sub